#version 330 core
in vec4 vertex_color;
out vec4 fragColor;

uniform sampler2D tex;

uniform float xy_scale;
uniform vec2 x_bounds;
uniform vec2 y_bounds;
uniform vec3 xy_color;


void main() {
    vec2 high = vec2(x_bounds.x, y_bounds.x);
    vec2 low = vec2(x_bounds.y, y_bounds.y);

    vec2 xy = (high - vertex_color.xy) / (high - low);
    vec4 pdf_enc = texture(tex, xy);

    float pdf = pdf_enc.x + pdf_enc.y/255.;

    fragColor = vec4(xy_color, xy_scale*pdf);
}
