#version 330 core
layout(location = 0) in vec2 vertexPosition_in;
layout(location = 1) in vec3 vertexColor_in;

out vec4 vertex_color;

uniform vec4 bounds;
uniform float n_trace;
uniform float vdiv;
uniform float vpos;

void main() {
    vec2 pos = vertexPosition_in;
//    pos.x += 0.5;
    pos.x /= (n_trace-1.);
    pos.x = mix(bounds.x, bounds.y, pos.x);
    pos.x = 2.*pos.x - 1.; // Scale to [-1, 1]

    if (!isnan(pos.y)) {
        pos.y += vpos;
        pos.y /= -vdiv;
        pos.y = clamp(pos.y/12. + 0.5, 0., 1.);
        pos.y = mix(bounds.z, bounds.w, pos.y) * 2. - 1.;
    }

    gl_Position = vec4(pos, 0., 1.);

    vertex_color = vec4(vertexColor_in, 1.);
}
