#version 330 core
in vec4 vertex_color;
out vec4 fragColor;

uniform sampler2D tex;

uniform float tn_light_mode;

uniform vec4 tn_low;
uniform vec4 tn_high;
uniform vec4 tn_visible;

vec2 get_trace(float channel) {
    vec4 data = texture(tex, vec2(vertex_color.x, 1/16. + channel/8.));
    return vec2(
        (255.*data.x + data.y)/100. - 1.1,
        exp((255.*data.z + data.w)/20. - 11.)
    );
}

void main() {
    vec2 ch1 = get_trace(0.);
    vec2 ch2 = get_trace(1.);
    vec2 ch3 = get_trace(2.);
    vec2 ch4 = get_trace(3.);

    vec4 nom = vec4(ch1.x, ch2.x, ch3.x, ch4.x);
    vec4 std = vec4(ch1.y, ch2.y, ch3.y, ch4.y);

    vec4 y0 = tn_low + (tn_high-tn_low) * (vertex_color.y);
    vec4 ymax = tn_low + (tn_high-tn_low) * 1.1;
    vec4 ymin = tn_low + (tn_high-tn_low) * -0.1;

    vec4 z = (y0 - nom)/std;
    vec4 mask2 = step(nom, ymax) * step(max(ymin, -1.08), nom);

    vec4 mask = mask2*tn_visible*0.5*step(abs(z), vec4(1., 1., 1., 1.));

    // Implement alpha composite passes
    float lm = 1.-0.5*tn_light_mode;
    vec4 pix = vec4(lm, lm, 0., 1.) * mask.x;
    pix = vec4(0., 0.75*lm, lm, 1.) * mask.y + (1.-mask.y) * pix;
    pix = vec4(lm, 0., lm, 1.) * mask.z + (1.-mask.z) * pix;
    pix = vec4(0., 0.94*lm, 0.313*lm, 1.) * mask.w + (1.-mask.w) * pix;

    fragColor = pix;
}
